# Standard textclass definition file. Taken from initial LyX source code
# Author : Ralf Herbrich <ralfh@cs.tu-berlin.de>

# This include files contains all the neccesary styles for the algorithmics
# package

# Quotation style definition
Style Algorithm
  Margin		Static
  LatexType		Environment
  LatexName		algorithmic
  KeepEmpty             1
  NextNoIndent		1
  LeftMargin		MMM
  RightMargin		MMM
  ParIndent		MM
  ParSkip		0
  ItemSep		0
  TopSep		0.5
  BottomSep		0.5
  ParSep		0
  Align			Center
  AlignPossible		Center
  LabelType		Static
  LabelString           "Algorithm"

  LabelFont 
    Family		Sans
    Series		Italic
  EndFont

  Preamble
    \usepackage{algorithmic}
  EndPreamble
End

# Require style definition
Style Require
  Margin		Static
  LatexType		Command
  LatexName		REQUIRE
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "Require: "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Ensure style definition
Style Ensure
  Margin		Static
  LatexType		Command
  LatexName		ENSURE
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "Ensure: "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# State style definition
Style State
  Margin		Static
  LatexType		Command
  LatexName		STATE
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "State: "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# AComment style definition
Style AComment
  Margin		Static
  LatexType		Command
  LatexName		COMMENT
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "Comment: "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# If style definition
Style If
  Margin		Static
  LatexType		Command
  LatexName		IF
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "if "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Else style definition
Style Else
  Margin		Static
  LatexType		Command
  LatexName		aelse
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "else "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aelse}[1]{\ELSE}
  EndPreamble
End

# Elsif style definition
Style Elsif
  Margin		Static
  LatexType		Command
  LatexName		aelsif
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "else if "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aelsif}[1]{\ELSIF}
  EndPreamble
End

# For style definition
Style For
  Margin		Static
  LatexType		Command
  LatexName		FOR
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "for "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Forall style definition
Style Forall
  Margin		Static
  LatexType		Command
  LatexName		FORALL
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "for all "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# While style definition
Style While
  Margin		Static
  LatexType		Command
  LatexName		WHILE
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "while "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Loop style definition
Style Loop
  Margin		Static
  LatexType		Command
  LatexName		LOOP
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "loop "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Repeat style definition
Style Repeat
  Margin		Static
  LatexType		Command
  LatexName		arepeat
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "repeat "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\arepeat}[1]{\REPEAT}
  EndPreamble
End

# Until style definition
Style Until
  Margin		Static
  LatexType		Command
  LatexName		UNTIL
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "until "
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont
End

# Endif style definition
Style Endif
  Margin		Static
  LatexType		Command
  LatexName		aendif
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "end if"
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aendif}[1]{\ENDIF}
  EndPreamble
End

# Endfor style definition
Style Endfor
  Margin		Static
  LatexType		Command
  LatexName		aendfor
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "end for"
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aendfor}[1]{\ENDFOR}
  EndPreamble
End

# Endwhile style definition
Style Endwhile
  Margin		Static
  LatexType		Command
  LatexName		aendwhile
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "end while"
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aendwhile}[1]{\ENDWHILE}
  EndPreamble
End

# Endloop style definition
Style Endloop
  Margin		Static
  LatexType		Command
  LatexName		aendloop
  NextNoIndent		1
  NeedProtect           0
  LeftMargin		MMM
  RightMargin		MMM
  TopSep		0.5
  ParSep		0.5
  BottomSep		0.5
  Align			Block
  AlignPossible		Block, Left, Right, Center
  LabelType		Static
  LabelString           "end loop"
  # label font definition

  LabelFont 
    Family		Sans
    Series		Bold
  EndFont

  Preamble
    \newcommand{\aendloop}[1]{\ENDLOOP}
  EndPreamble
End
