# R script consisting of the examples presented in the paper "Enhancing Identification of Causal Effects by Pruning" by
# Santtu Tikka and Juha Karvanen
# Last updated on 30 April 2018

# Version 1.3.6 or newer of "causaleffect" package is recommended for use
# If the pre-requisite packages are not available, uncomment the next line to install them
# install.packages(c("igraph", "causaleffect"))

library("igraph")
library("causaleffect")

# Intro
intro <- graph.formula(w_1 -+ w_2, w_1 -+ x, w_2 -+ x, z_2 -+ x, x -+ z_1,
  z_2 -+ z_1, z_2 -+ z_3, z_4 -+ z_1, z_1 -+ y, z_3 -+ y, 
  w_1 -+ w_2, w_2 -+ w_1, w_1 -+ x, x -+ w_1, w_2 -+ x, x -+ w_2, 
  z_4 -+ z_1, Z_1 -+ z_4, x -+ y, y -+ x, z_2 -+ y, y -+ z_2, x -+ z_3,
  z_3 -+ x, x -+ z_2, z_2 -+ x, simplify = FALSE)
intro <- set.edge.attribute(intro, "description", 11:26, "U")
cat(causal.effect("y", "x", G = intro, simp = FALSE, primes = TRUE))
cat(causal.effect("y", "x", G = intro, simp = TRUE,  primes = TRUE))
cat(causal.effect("y", "x", G = intro, simp = FALSE, primes = TRUE, prune = TRUE))

# Corollary 11
cor1a <- graph.formula(w_1 -+ w_2, w_1 -+ x, w_2 -+ x, x -+ z, z -+ y,
  w_1 -+ w_2, w_2 -+ w_1, w_1 -+ x, x -+ w_1, x -+ y, y -+ x, simplify = FALSE)
cor1a <- set.edge.attribute(cor1a, "description", 7:12, "U")
cat(causal.effect("y", "x", G = cor1a, prune = FALSE, primes = TRUE))
cat(causal.effect("y", "x", G = cor1a, prune = TRUE,  primes = TRUE))

cor1b <- graph.formula(w_1 -+ x_1, x_1 -+ y_1, w_2 -+ w_1, w_2 -+ x_2,
  x_2 -+ z, z -+ y_2, z -+ y_1, w_1 -+ w_2, w_2 -+ w_1, w_1 -+ x_1, x_1 -+ w_1,
  w_2 -+ x_2, x_2 -+ w_2, x_1 -+ z, z -+ x_1, x_2 -+ y_2, y_2 -+ x_2, x_1 -+ x_2, x_2 -+ x_1, simplify = FALSE)
cor1b <- set.edge.attribute(cor1b, "description", 8:19, "U")
cat(causal.effect(c("y_1", "y_2"), c("w_1", "x_1", "x_2"), G = cor1b, prune = FALSE, primes = TRUE))
cat(causal.effect(c("y_1", "y_2"), c("w_1", "x_1", "x_2"), G = cor1b, prune = TRUE,  primes = TRUE))

# Corollary 13
cor2a <- graph.formula(x -+ z, z -+ y, w_1 -+ z, w_1 -+ w_2, w_2 -+ z,
  w_1 -+ w_2, w_2 -+ w_1, w_1 -+ z, z -+ w_1, x -+ y, y -+ x, simplify = FALSE)
cor2a <- set.edge.attribute(cor2a, "description", 6:11, "U")
cat(causal.effect("y", "x", G = cor2a, prune = FALSE, primes = TRUE))
cat(causal.effect("y", "x", G = cor2a, prune = TRUE,  primes = TRUE))

cor2b <- graph.formula(x -+ y, z_1 -+ x, z_2 -+ z_1, w_1 -+ z_2, w_1 -+ w_2, w_2 -+ z_2,
  x -+ z_2, z_2 -+ x, z_2 -+ y, y -+ z_2, w_1 -+ w_2, w_2 -+ w_1, w_2 -+ z_2, z_2 -+ w_2, simplify = FALSE)
cor2b <- set.edge.attribute(cor2b, "description", 7:14, "U")
cat(causal.effect("y", "x", G = cor2b, prune = FALSE, primes = TRUE))
cat(causal.effect("y", "x", G = cor2b, prune = TRUE,  primes = TRUE))

# Corollary 16
cor3 <- graph.formula(x -+ z_1, z_1 -+ y, z_3 -+ y, z_2 -+ x, z_2 -+ z_1, z_2 -+ z_3,
  x -+ y, y -+ x, x -+ z_3, z_3 -+ x, x -+ z_2, z_2 -+ x, y -+ z_2, z_2 -+ y, simplify = FALSE)
cor3 <- set.edge.attribute(graph = cor3, name = "description", index = 7:14, value = "U")

cor3l <- graph.formula(x -+ z_1, z_1 -+ y, z_2 -+ x, z_2 -+ z_1, z_2 -+ y,
  x -+ y, y -+ x, x -+ z_2, z_2 -+ x, y -+ z_2, z_2 -+ y, simplify = FALSE)
cor3l <- set.edge.attribute(graph = cor3l, name = "description", index = 6:11, value = "U")

cat(causal.effect("y", "x", G = cor3,  primes = TRUE))
cat(causal.effect("y", "x", G = cor3l, primes = TRUE))
cat(causal.effect("y", "x", G = cor3,  prune = TRUE, primes = TRUE))


# Additional examples (recursive pruning and pruning together with simplification)
rec1 <- graph.formula(x -+ z_4, z_4 -+ y, z_3 -+ x, z_3 -+ z_2, z_2 -+ z_1, z_1 -+ x,
  x -+ z_3, z_3 -+ x, z_2 -+ x, x -+ z_2, z_4 -+ y, y -+ z_4, z_2 -+ y, y -+ z_2, simplify = FALSE)
rec1 <- set.edge.attribute(rec1, "description", 7:14, "U")
cat(causal.effect("y", "x", G = rec1, primes = TRUE, simp = FALSE))
cat(causal.effect("y", "x", G = rec1, primes = TRUE, simp = FALSE, prune = TRUE))

rec2 <- graph.formula(x -+ y, z_1 -+ x, z_2 -+ z_1, z_3 -+ z_1, z_3 -+ y,
  x -+ z_2, z_2 -+ x, z_2 -+ y, y -+ z_2, z_3 -+ y, y -+ z_3, simplify = FALSE)
rec2 <- set.edge.attribute(rec2, "description", 6:11, "U")
cat(causal.effect("y", "x", G = rec2, primes = TRUE, simp = FALSE))
cat(causal.effect("y", "x", G = rec2, primes = TRUE, simp = FALSE, prune = TRUE))
cat(causal.effect("y", "x", G = rec2, primes = TRUE, simp = TRUE,  prune = FALSE))
cat(causal.effect("y", "x", G = rec2, primes = TRUE, simp = TRUE,  prune = TRUE))

rec3 <- graph.formula(x -+ w, w -+ y, z_2 -+ z_1, z_1 -+ x,
  z_2 -+ x, x -+ z_2, w -+ y, y -+ w, z_2 -+ y, y -+ z_2, simplify = FALSE)
rec3 <- set.edge.attribute(rec3, "description", 5:10, "U")
cat(causal.effect("y", "x", G = rec3, primes = TRUE, simp = FALSE))
cat(causal.effect("y", "x", G = rec3, primes = TRUE, simp = FALSE, prune = TRUE))

rec4 <- graph.formula(x -+ z_4, z_4 -+ y, z_1 -+ x, z_2 -+ z_1, z_3 -+ z_2, z_3 -+ x,
  z_5 -+ z_1, z_5 -+ z_4, 
  x -+ z_2, z_2 -+ x, z_3 -+ z_2, z_2 -+ z_3, z_2 -+ y, y -+ z_2,
  z_4 -+ y, y -+ z_4, z_5 -+ z_4, z_4 -+ z_5, simplify = FALSE)
rec4 <- set.edge.attribute(rec4, "description", 9:18, "U")
cat(causal.effect("y", "x", G = rec4, primes = TRUE, simp = FALSE, prune = FALSE))
cat(causal.effect("y", "x", G = rec4, primes = TRUE, simp = FALSE, prune = TRUE))
cat(causal.effect("y", "x", G = rec4, primes = TRUE, simp = TRUE,  prune = TRUE))

